# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdapiobject import SDAPIObject
from .sdbasetypes import ColorRGB
from .sdbasetypes import ColorRGBA
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDColorSpace(SDAPIObject):
    """
    A set of helper functions to convert colors from one color-space to another
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDColorSpace
        """
        super(SDColorSpace, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sConvert(value : float, valueColorSpaceName : str, dstColorSpaceName : str) -> float:
        """
        Convert a float value from one color space to another. Supported color space names are: 'sRGB', 'Linear'

        :param value: The float value to convert
        :param valueColorSpaceName: The color space of the provided value
        :param dstColorSpaceName: The color space wanted for the output value
        """
        outValue = ctypes.c_float()
        _res = sd.getContext().SDColorSpace_sConvert(value, ctypes.create_string_buffer(valueColorSpaceName.encode('utf-8')), ctypes.create_string_buffer(dstColorSpaceName.encode('utf-8')), ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    @staticmethod
    def sConvertColorRGB(value : ColorRGB, valueColorSpaceName : str, dstColorSpaceName : str) -> ColorRGB:
        """
        Convert a ColorRGB value from one color space to another. Supported color space names are: 'sRGB', 'Linear'

        :param value: The float value to convert
        :param valueColorSpaceName: The color space of the provided value
        :param dstColorSpaceName: The color space wanted for the output value
        """
        outValue = ColorRGB()
        _res = sd.getContext().SDColorSpace_sConvertColorRGB(ctypes.byref(value), ctypes.create_string_buffer(valueColorSpaceName.encode('utf-8')), ctypes.create_string_buffer(dstColorSpaceName.encode('utf-8')), ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue

    @staticmethod
    def sConvertColorRGBA(value : ColorRGBA, valueColorSpaceName : str, dstColorSpaceName : str) -> ColorRGBA:
        """
        Convert a ColorRGBA value from one color space to another. Supported color space names are: 'sRGB', 'Linear'. Alpha component is left unchanged

        :param value: The float value to convert
        :param valueColorSpaceName: The color space of the provided value
        :param dstColorSpaceName: The color space wanted for the output value
        """
        outValue = ColorRGBA()
        _res = sd.getContext().SDColorSpace_sConvertColorRGBA(ctypes.byref(value), ctypes.create_string_buffer(valueColorSpaceName.encode('utf-8')), ctypes.create_string_buffer(dstColorSpaceName.encode('utf-8')), ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue

